/* $Id$ */

#include <ctype.h>
#include "model.h"
#include "throw.h"
#include "intl.h"

CModel::CModel(const std::string &modelName): m_model(MODEL_UVD1)
{
	if (modelName.empty())
		return;

	std::string s;
	s.reserve(modelName.size());

	for (std::string::const_iterator i(modelName.begin()); i != modelName.end(); ++i)
		s.push_back(toupper(*i));

	if (s == "UVD1")
		m_model = MODEL_UVD1;
	else if (s == "UVD3")
		m_model = MODEL_UVD3;
	else if (s == "UVA1")
		m_model = MODEL_UVA1;
	else
		Throw(_("Unsupported model %s, see README"), s.c_str());
}

CModel::EModel CModel::GetModel() const
{
	return m_model;
}

unsigned CModel::GetChannelsCount() const
{
	return m_model == MODEL_UVA1 ? 16 : 128;
}

unsigned CModel::GetRangesOffset() const
{
	return m_model == MODEL_UVA1 ? 0x300 : 0x900;
}

bool CModel::UseFmRadio() const
{
	return m_model != MODEL_UVA1;
}

bool CModel::UseWelcomeMessage() const
{
	return m_model == MODEL_UVD3;
}

bool CModel::UseChannelNames() const
{
	return m_model != MODEL_UVA1;
}

unsigned CModel::GetMemorySize() const
{
	return m_model == MODEL_UVA1 ? 0x1000 : 0x2000;
}

unsigned CModel::GetRows() const
{
	// to be changed

	// UVD1:
	// - 1 header
	// - 128 channels
	// - 1 space
	// - 4 ranges
	// - 1 space
	// - 9 fm radio list
	// total: 144

	// UVD3:
	// - 144 UVD1
	// - 1 space
	// - 1 welcome message
	// total: 146

	// UVA1:
	// - 1 header
	// - 16 channels
	// - 1 space
	// - 4 ranges
	// - 1 space
	// - 1 programable button function
	// - 1 vox activation and level
	// - 1 roger beep
	// - 1 battery save flag
	// - 1 squelch level
	// - 1 TOT
	// - 1 TOA
	// - 1 Voice guide
	// - 1 Beep flag
	// - 1 Priority channel
	// total: 33

	if (m_model == MODEL_UVA1)
		return 33;

	if (m_model == MODEL_UVD3)
		return 146;

	return 144;
}

unsigned CModel::GetCols() const
{
	// - ch
	// - name
	// - rx freq
	// - tx freq
	// - rx ctc
	// - tx ctc
	// - deviation
	// - tx power
	// - scan
	// - bcl

	return 10;
}

std::string CModel::GetIdString() const
{
	return "KG669V";
}
