/* $Id$ */

#pragma once

#include <string>

class CModel
{
public:
	enum EModel
	{
		MODEL_UVD1,
		MODEL_UVD3,
		MODEL_UVA1
	};

	// modelName can be empty, it defaults to UVD1 then
	CModel(const std::string &modelName);

	EModel GetModel() const;
	unsigned GetChannelsCount() const;
	unsigned GetRangesOffset() const;
	bool UseFmRadio() const;
	bool UseWelcomeMessage() const;
	bool UseChannelNames() const;
	unsigned GetMemorySize() const;
	unsigned GetRows() const;
	unsigned GetCols() const;
	std::string GetIdString() const;

private:
	EModel m_model;
};
