/* $Id$ */

#pragma once

#include <vector>
#include <cstdio>

class CFskEncoder
{
public:
	CFskEncoder();

	void Feed(const char *data, unsigned size);
	void Write(FILE *fp);
	void Terminate();

private:
	enum EType
	{
		TYPE_START = 0x00,
		TYPE_DATA = 0x01,
		TYPE_END = 0x02
	};

	// data vector before modulation
	std::vector<unsigned char> m_data;
	unsigned char m_index;
	double m_angle;
	bool m_generateLeadIn;
	bool m_generateLeadOut;

	void EnqueuePacket(EType type, const char *payload, unsigned size);
	void GenerateTone(FILE *fp, bool isMark);
	void GenerateLead(FILE *fp);
};
